% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMOUNTAIN.R
\name{EuclideanProjectionENNORM}
\alias{EuclideanProjectionENNORM}
\title{Euclidean projection on elastic net}
\usage{
EuclideanProjectionENNORM(y, t, alpha = 0.5)
}
\arguments{
\item{y}{constant vector}

\item{t}{radius of elastic net ball}

\item{alpha}{parameter in elastic net: alpha x_1 + (1-alpha)*x_2^2=t}
}
\value{
a list containing network adjacency matrix, node score and module membership
}
\description{
Piecewise root finding algorithm for Euclidean projection on elastic net
}
\examples{
y=rnorm(100)
x=EuclideanProjectionENNORM(y,1,0.5)
sparistyx = sum(x==0)/100
}
\author{
Dong Li, \email{dxl466@cs.bham.ac.uk}
}
\references{
Gong, Pinghua, Kun Gai, and Changshui Zhang. "Efficient euclidean projections via piecewise root finding and its application in gradient projection." Neurocomputing 74.17 (2011): 2754-2766.
}
\keyword{Euclidean}
\keyword{projection}

