% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{callParameter}
\alias{callParameter}
\title{Calculate parameters for differential expression test base on absolute counts differences}
\usage{
callParameter(object, replaceOutliers = TRUE, ...)
}
\arguments{
\item{object}{a \code{\link{ABSDataSet}} object.}

\item{replaceOutliers}{switch for outlier replacement, default is TRUE.}

\item{...}{parameters past to \code{\link{ReplaceOutliersByMAD}}}
}
\value{
A ABSDataSet object with absolute differences, basemean, mean of each group, variance, 
log2 of foldchange, named as 'absD', 'baseMean', 'Amean', 'Bmean', 
 'Variance' and 'foldChange', respectively. Use the \code{\link{results}} to get access it and \code{\link{plotDifftoBase}} to plot it.
}
\description{
Calculate parameters for each gene (the moderating basemean, dispersions, moderated fold-change and general sd)
}
\details{
shifted and calculate a set of parameters from normalized counts table before \code{\link{callDEs}}
}
\note{
This function should run after \code{\link{normalFactors}} or providing size factors.
}
\examples{

data(simuN5)
obj <- ABSDataSet(counts=simuN5$counts, groups=factor(simuN5$groups))
obj <- normalFactors(obj)
obj <- callParameter(obj)
head(results(obj,c("foldChange","absD","baseMean")))
plotDifftoBase(obj)

}
