/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;

public class CompoundLocation
implements Location,
Serializable {
    private List locations;
    private int min = Integer.MAX_VALUE;
    private int max = Integer.MIN_VALUE;

    public CompoundLocation(List list) {
        Location location;
        Iterator iterator;
        this.locations = new ArrayList();
        ArrayList<Location> arrayList = new ArrayList<Location>();
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            iterator = ((Location)iterator2.next()).blockIterator();
            while (iterator.hasNext()) {
                location = (Location)iterator.next();
                if (location == Location.empty) continue;
                arrayList.add(location);
            }
        }
        Collections.sort(arrayList, Location.naturalOrder);
        iterator = arrayList.iterator();
        location = Location.empty;
        if (iterator.hasNext()) {
            location = (Location)iterator.next();
        }
        while (iterator.hasNext()) {
            Location location2 = (Location)iterator.next();
            if (location.overlaps(location2)) {
                location = new RangeLocation(Math.min(location.getMin(), location2.getMin()), Math.max(location.getMax(), location2.getMax()));
                continue;
            }
            if (location != Location.empty) {
                this.locations.add(location);
            }
            location = location2;
        }
        if (location != Location.empty) {
            this.locations.add(location);
        }
        if (this.locations.size() != 0) {
            this.min = ((Location)this.locations.get(0)).getMin();
            this.max = ((Location)this.locations.get(this.locations.size() - 1)).getMax();
        }
    }

    public Iterator blockIterator() {
        return this.locations.iterator();
    }

    public boolean contains(int n) {
        if (n < this.min || n > this.max) {
            return false;
        }
        Iterator iterator = this.locations.iterator();
        while (iterator.hasNext()) {
            if (!((Location)iterator.next()).contains(n)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Location location) {
        if (location.getMin() > this.max || location.getMax() < this.min) {
            return false;
        }
        Iterator iterator = this.locations.iterator();
        while (iterator.hasNext()) {
            if (!((Location)iterator.next()).contains(location)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof Location) {
            return Location.naturalOrder.areEqual(this, (Location)object);
        }
        return false;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public Location intersection(Location location) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        Iterator iterator = this.locations.iterator();
        while (iterator.hasNext()) {
            Location location2 = ((Location)iterator.next()).intersection(location);
            if (location2 == Location.empty) continue;
            arrayList.add(location2);
        }
        if (arrayList.size() != 0) {
            return new CompoundLocation(arrayList);
        }
        return Location.empty;
    }

    public boolean isContiguous() {
        return this.locations.size() <= 1;
    }

    public boolean overlaps(Location location) {
        if (location.getMin() > this.max || location.getMax() < this.min) {
            return false;
        }
        Iterator iterator = this.locations.iterator();
        while (iterator.hasNext()) {
            if (!((Location)iterator.next()).overlaps(location)) continue;
            return true;
        }
        return false;
    }

    public SymbolList symbols(SymbolList symbolList) {
        if (this.isContiguous()) {
            return symbolList.subList(this.min, this.max);
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.blockIterator();
        while (iterator.hasNext()) {
            Location location = (Location)iterator.next();
            arrayList.addAll(location.symbols(symbolList).toList());
        }
        try {
            return new SimpleSymbolList(symbolList.getAlphabet(), arrayList);
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.getMin()) + ", " + this.getMax() + " {");
        Iterator iterator = this.locations.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append("(" + iterator.next() + ")");
        }
        while (iterator.hasNext()) {
            stringBuffer.append(", (" + iterator.next() + ")");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Location translate(int n) {
        if (n == 0) {
            return this;
        }
        ArrayList<Location> arrayList = new ArrayList<Location>();
        Iterator iterator = this.locations.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Location)iterator.next()).translate(n));
        }
        return new CompoundLocation(arrayList);
    }

    public Location union(Location location) {
        ArrayList<Location> arrayList = new ArrayList<Location>(this.locations);
        arrayList.add(location);
        return new CompoundLocation(arrayList);
    }
}

