## ----eval = FALSE-------------------------------------------------------------
# 
# if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
# BiocManager::install("findIPs")
# 

## -----------------------------------------------------------------------------
library(findIPs)
data(miller05)
X <- miller05$X
y <- miller05$y
surv <- miller05$surv

## -----------------------------------------------------------------------------

obj <- getdrop1ranks(X, y,
                     fun = "t.test",
                     decreasing = FALSE,
                     topN = 100)
str(obj)


## -----------------------------------------------------------------------------

results <- sumRanks(origRank = obj$origRank,
                    drop1Rank = obj$drop1Rank,
                    topN = 100,
                    method = "adaptive")

str(results)


## -----------------------------------------------------------------------------
results.ipsr <- findIPs(X, y, 
                        fun = "t.test",
                        decreasing = FALSE,
                        method = "adaptive")

identical(results, results.ipsr)

## ----fig.width = 7, fig.height = 4, fig.cap = "Figure 1, the influence scores for each observation"----
par(mar = c(4, 4, 2, 2))
plotIPs(results.ipsr, topn = 5, ylim = c(0, 8))


## ----fig.width = 7, fig.height = 4, fig.cap = "Figure 2, the distribution of rank changes"----
par(mar = c(4, 4, 2, 2))
plotRankScatters(results.ipsr)


## ----fig.width = 7, fig.height = 4, fig.cap = "Figure 3, the weight function of the adaptive weights"----
par(mar = c(4, 4, 2, 2))
plotAdaptiveWeights(results.ipsr$kappa, n = 100, type = "line")


## ----fig.width = 7, fig.height = 4, fig.cap = "Figure 4, IPs detection for survival data"----
par(mar = c(4, 4, 2, 2))
results.cox <- findIPs(X, surv, 
                       fun = "cox",
                       decreasing = FALSE,
                       method = "adaptive")

plotIPs(results.cox)

## -----------------------------------------------------------------------------
fun <- function(x, y){
  kruskal.test(x, y)$p.value
}

kruskal.test1 <- getdrop1ranks(X, y, 
                               fun = fun, 
                               decreasing = FALSE)

kruskal.test2 <- getdrop1ranks(X, y, 
                               fun = "kruskal.test", 
                               decreasing = FALSE)

identical(kruskal.test1, kruskal.test2)


## ----fig.width = 9, fig.height = 3, fig.cap = "Figure 5, IPs detection using three rank comparison methods"----
re.unweighted <- findIPs(X, y, 
                         fun = "t.test",
                         decreasing = FALSE,
                         method = "unweighted")
re.weighted <- findIPs(X, y, 
                       fun = "t.test",
                       decreasing = FALSE,
                       method = "weightedSpearman")
re.adaptive <- findIPs(X, y, 
                       fun = "t.test",
                       decreasing = FALSE,
                       method = "adaptive")

par(mfrow = c(1, 3), mar = c(4, 4, 2, 2))
plotIPs(re.unweighted)
mtext("A, unweighted", side = 3, line = 0, adj = 0)
plotIPs(re.weighted)
mtext("B, weighted Spearman", side = 3, line = 0, adj = 0)
plotIPs(re.adaptive)
mtext("C, adaptive weights", side = 3, line = 0, adj = 0)


## ----echo = F-----------------------------------------------------------------
sessionInfo()

