/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.javautils;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.gkano.bioinfo.var.GeneralTools;
import com.gkano.bioinfo.var.Logger;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.IntervalXYDataset;

@Parameters(commandDescription="DIST2Hist")
public class UtilDIST2Hist {
    private static UtilDIST2Hist instance = new UtilDIST2Hist();
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    @Parameter(description="<input file>", required=true)
    private String inputFileName;
    @Parameter(names={"--output", "-o"}, description="Output png image file", required=true)
    private String outputFileName = null;
    @Parameter(names={"--settings", "-s"}, description="Settings for bins,width,height")
    private String settings = "100,1024,768";

    private UtilDIST2Hist() {
    }

    public static UtilDIST2Hist getInstance() {
        return instance;
    }

    public static String getUtilName() {
        return "DIST2Hist";
    }

    public void go() {
        try {
            Object[] data = GeneralTools.readDistancesSamples(this.inputFileName);
            JFreeChart hist = this.createHistogram((String[])data[1], (double[][])data[0], this.settings);
            BufferedImage bImage = hist.createBufferedImage(Integer.parseInt(this.settings.split(",")[1]), Integer.parseInt(this.settings.split(",")[2]), null);
            try (FileOutputStream os = new FileOutputStream(this.outputFileName);){
                ImageIO.write((RenderedImage)bImage, "png", os);
            }
        }
        catch (IOException | NumberFormatException e) {
            Logger.error(this, e.getMessage());
        }
    }

    private JFreeChart createHistogram(String[] sampleNames, double[][] distances, String settings) {
        try {
            ArrayList<Double> dataList = new ArrayList<Double>();
            for (int i = 0; i < sampleNames.length; ++i) {
                for (int j = i; j < sampleNames.length; ++j) {
                    if (Double.isNaN(distances[i][j])) continue;
                    dataList.add(distances[i][j]);
                }
            }
            double[] data = dataList.stream().mapToDouble(Double::doubleValue).toArray();
            HistogramDataset dataset = new HistogramDataset();
            dataset.setType(HistogramType.FREQUENCY);
            dataset.addSeries((Comparable)((Object)"Hist"), data, Integer.parseInt(settings.split(",")[0]));
            String plotTitle = "";
            String xAxis = "Distance";
            String yAxis = "Density";
            JFreeChart chart = ChartFactory.createHistogram((String)plotTitle, (String)xAxis, (String)yAxis, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.white);
            return chart;
        }
        catch (NumberFormatException e) {
            Logger.error(this, e.getMessage());
            return null;
        }
    }
}

