/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.var;

import com.gkano.bioinfo.var.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PrimitiveIterator;

public class GeneralTools {
    public static final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    public static final DecimalFormat decimalFormat = new DecimalFormat("#.######", new DecimalFormatSymbols(Locale.US));
    private static PrimitiveIterator.OfInt prng;
    private static GeneralTools instance;

    private GeneralTools() {
    }

    public static GeneralTools getInstance() {
        if (instance == null) {
            instance = new GeneralTools();
        }
        return instance;
    }

    public static int getRandomInteger() {
        return prng.nextInt();
    }

    public static PrintStream getPrintStreamOrExit(String outputFile, Object context) {
        try {
            return outputFile == null ? System.out : new PrintStream(outputFile);
        }
        catch (FileNotFoundException | SecurityException e) {
            Logger.error(context, "Cannot write to " + outputFile);
            System.exit(1);
            return null;
        }
    }

    public static String time() {
        Calendar cal = Calendar.getInstance();
        return dateFormat.format(cal.getTime());
    }

    public static String RAMInfo(Runtime runtime) {
        double gb = 1.073741824E9;
        NumberFormat format = NumberFormat.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append("\n##### Heap utilization statistics [GB] #####\n");
        sb.append("Max Memory=").append(format.format((double)runtime.maxMemory() / gb)).append("\n");
        sb.append("Current Total Memory=").append(format.format((double)runtime.totalMemory() / gb)).append("\n");
        sb.append("Current Used Memory=").append(format.format((double)(runtime.totalMemory() - runtime.freeMemory()) / gb)).append("\n");
        sb.append("Current Free Memory=").append(format.format((double)runtime.freeMemory() / gb)).append("\n");
        sb.append("############################################\n");
        return sb.toString();
    }

    public static final byte[][] concatSeqQual(ArrayList<byte[]> arrays) {
        byte[] all = GeneralTools.concat(arrays);
        int size = all.length;
        int sizeSeq = 0;
        int sizeQual = 0;
        for (byte b : all) {
            if ('+' == (char)(b & 0xFF)) {
                sizeQual = size - sizeSeq - 1;
                break;
            }
            ++sizeSeq;
        }
        byte[][] ret = new byte[2][];
        if (sizeSeq > 0) {
            byte[] destSeq = new byte[sizeSeq];
            System.arraycopy(all, 0, destSeq, 0, sizeSeq);
            ret[0] = destSeq;
        }
        if (sizeQual > 0) {
            byte[] destQual = new byte[sizeQual];
            System.arraycopy(all, sizeSeq + 1, destQual, 0, sizeQual);
            ret[1] = destQual;
        }
        return ret;
    }

    public static final byte[] concat(ArrayList<byte[]> arrays) {
        int size = 0;
        for (byte[] a : arrays) {
            size += a.length;
        }
        byte[] dest = new byte[size];
        int destPos = 0;
        for (int i = 0; i < arrays.size(); ++i) {
            if (i > 0) {
                destPos += arrays.get(i - 1).length;
            }
            int length = arrays.get(i).length;
            System.arraycopy(arrays.get(i), 0, dest, destPos, length);
        }
        return dest;
    }

    public static int round(double d) {
        int i;
        double dAbs = Math.abs(d);
        double result = dAbs - (double)(i = (int)dAbs);
        if (result < 0.5) {
            return d < 0.0 ? -i : i;
        }
        return d < 0.0 ? -(i + 1) : i + 1;
    }

    public static char[] bytesToStringUTFCustom(byte[] bytes) {
        char[] buffer = new char[bytes.length >> 1];
        for (int i = 0; i < buffer.length; ++i) {
            char c;
            int bpos = i << 1;
            buffer[i] = c = (char)(((bytes[bpos] & 0xFF) << 8) + (bytes[bpos + 1] & 0xFF));
        }
        return buffer;
    }

    public static byte[] stringToBytesUTFCustom(char[] str) {
        byte[] b = new byte[str.length << 1];
        for (int i = 0; i < str.length; ++i) {
            char strChar = str[i];
            int bpos = i << 1;
            b[bpos] = (byte)((strChar & 0xFF00) >> 8);
            b[bpos + 1] = (byte)(strChar & 0xFF);
        }
        return b;
    }

    public static List<String> directoriesToFiles(List<String> inputFastaFileNames) {
        ArrayList<String> outputFastaFileNames = new ArrayList<String>();
        try {
            for (String s : inputFastaFileNames) {
                File f = new File(s);
                if (!f.isDirectory()) {
                    outputFastaFileNames.add(f.getCanonicalPath());
                    continue;
                }
                for (File ff : f.listFiles()) {
                    outputFastaFileNames.add(ff.getCanonicalPath());
                }
            }
        }
        catch (IOException e) {
            Logger.error(GeneralTools.class, e.getMessage());
        }
        return outputFastaFileNames;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, (o1, o2) -> {
            int compare = ((Comparable)o1.getValue()).compareTo(o2.getValue());
            if (compare == 0) {
                Long key1 = (Long)o1.getKey();
                Long key2 = (Long)o2.getKey();
                return 1 * key1.compareTo(key2);
            }
            return -1 * compare;
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return result;
    }

    public static ArrayList<String> generateKmerVocabulary(int k) {
        ArrayList<String> vocabulary = new ArrayList<String>();
        char[] chars = "ATCG".toCharArray();
        int len = k;
        GeneralTools.iterate(chars, len, new char[len], 0, vocabulary);
        return vocabulary;
    }

    private static void iterate(char[] chars, int len, char[] build, int pos, ArrayList<String> vocabulary) {
        if (pos == len) {
            String word = new String(build);
            vocabulary.add(word);
            return;
        }
        for (int i = 0; i < chars.length; ++i) {
            build[pos] = chars[i];
            GeneralTools.iterate(chars, len, build, pos + 1, vocabulary);
        }
    }

    public static final String reverseComplement(String sequence) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = sequence.length() - 1; i >= 0; --i) {
            switch (sequence.charAt(i)) {
                case 'A': 
                case 'a': {
                    sb.append("T");
                    continue block6;
                }
                case 'T': 
                case 't': {
                    sb.append("A");
                    continue block6;
                }
                case 'C': 
                case 'c': {
                    sb.append("G");
                    continue block6;
                }
                case 'G': 
                case 'g': {
                    sb.append("C");
                    continue block6;
                }
            }
        }
        return sb.toString();
    }

    public static long classBuildTimeMillis(Class c) {
        URL resource = c.getResource(c.getSimpleName() + ".class");
        if (resource == null) {
            System.out.println("Failed to find class file for class: " + c.getName());
            return 0L;
        }
        switch (resource.getProtocol()) {
            case "file": {
                try {
                    return new File(resource.toURI()).lastModified();
                }
                catch (URISyntaxException e) {
                    Logger.error(GeneralTools.class, e.getMessage());
                    return 0L;
                }
            }
            case "jar": {
                String path = resource.getPath();
                return new File(path.substring(5, path.indexOf("!"))).lastModified();
            }
        }
        System.out.println("Unhandled url protocol: " + resource.getProtocol() + " for class: " + c.getName() + " resource: " + resource.toString());
        return 0L;
    }

    public static <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }

    public static String[] reorderLabels(String[] original, String treeString) {
        String[] labelsReordered = new String[original.length];
        String[] data = treeString.split(",");
        for (int i = 0; i < data.length; ++i) {
            String label = data[i].trim();
            if (label.contains("(")) {
                label = label.substring(label.lastIndexOf("(") + 1);
            }
            if (label.contains(")")) {
                label = label.substring(0, label.indexOf(")"));
            }
            if (label.contains(":")) {
                label = label.substring(0, label.indexOf(":"));
            }
            labelsReordered[i] = label;
        }
        return labelsReordered;
    }

    public static double[][] reorderDistances(double[][] distancesOriginal, String[] labelsOriginal, String[] labelsReordered) {
        int i;
        int size = distancesOriginal.length;
        double[][] distancesReordered = new double[size][size];
        int[] indexToReorder = new int[size];
        block0: for (i = 0; i < size; ++i) {
            String labelOriginal = labelsOriginal[i].trim();
            for (int j = 0; j < size; ++j) {
                String labelReordered = labelsReordered[j].trim();
                if (!labelOriginal.equalsIgnoreCase(labelReordered)) continue;
                indexToReorder[i] = j;
                continue block0;
            }
        }
        for (i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                distancesReordered[indexToReorder[i]][indexToReorder[j]] = distancesOriginal[i][j];
            }
        }
        return distancesReordered;
    }

    public static Object[] readDistancesSamples(String input) {
        try {
            Object[] data;
            try (FileInputStream fis = new FileInputStream(input);){
                data = GeneralTools.readDistancesSamples(fis);
            }
            return data;
        }
        catch (IOException e) {
            Logger.error(GeneralTools.class, e.getMessage());
            return null;
        }
    }

    public static Object[] readDistancesSamples(InputStream input) {
        try {
            String[] sampleNames;
            double[][] distances;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(input));){
                String line = br.readLine();
                System.err.println(line);
                int numOfSamples = Integer.parseInt(line.split("[\\s,\\t]+")[0]);
                distances = new double[numOfSamples][numOfSamples];
                sampleNames = new String[numOfSamples];
                int i = 0;
                while ((line = br.readLine()) != null) {
                    String[] data = line.split("[\\s,\\t]+");
                    sampleNames[i] = data[0].trim();
                    for (int j = 0; j < numOfSamples; ++j) {
                        try {
                            distances[i][j] = Double.parseDouble(data[j + 1]);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            distances[i][j] = 1.0;
                        }
                    }
                    ++i;
                }
            }
            Object[] ret = new Object[]{distances, sampleNames};
            return ret;
        }
        catch (IOException | NumberFormatException e) {
            Logger.error(GeneralTools.class, e.getMessage());
            return null;
        }
    }

    public static boolean isGZipped(File f) {
        int magic = 0;
        try (RandomAccessFile raf = new RandomAccessFile(f, "r");){
            magic = raf.read() & 0xFF | raf.read() << 8 & 0xFF00;
        }
        catch (IOException e) {
            Logger.error(GeneralTools.class, e.getMessage());
        }
        return magic == 35615;
    }

    public static int getAdaptiveVariantStep(int count) {
        if (count < 10000) {
            return 100;
        }
        if (count < 100000) {
            return 1000;
        }
        if (count < 1000000) {
            return 10000;
        }
        return 100000;
    }

    public static int getAdaptiveSampleStep(int count) {
        if (count < 100) {
            return 10;
        }
        if (count < 1000) {
            return 100;
        }
        return 1000;
    }

    static {
        try {
            SecureRandom random = new SecureRandom();
            prng = random.ints().distinct().iterator();
        }
        catch (Exception e) {
            Logger.error(GeneralTools.class, e.getMessage());
        }
    }
}

