/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment;

import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import edu.msu.cme.rdp.readseq.utils.ProteinUtils;
import edu.msu.cme.rdp.readseq.utils.SeqUtils;
import edu.msu.cme.rdp.readseq.writers.FastaWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;

public class AlignNucleotideToProtein {
    public static void main(String[] args) throws Exception {
        Sequence seq2;
        if (args.length != 4) {
            System.err.println("USAGE: AlignNucleotideToProtein <aligned prot seqs> <unaligned_nucl_seqs> <aligned nucl out> <stats out>");
            return;
        }
        File alignProtSeqFile = new File(args[0]);
        File nuclSeqFile = new File(args[1]);
        File alignedNuclOutFile = new File(args[2]);
        File statsOut = new File(args[3]);
        HashMap<String, Sequence> protTemplateMap = new HashMap<String, Sequence>();
        for (Sequence seq2 : SequenceReader.readFully((File)alignProtSeqFile)) {
            protTemplateMap.put(seq2.getSeqName(), seq2);
        }
        SequenceReader nuclSeqReader = new SequenceReader(nuclSeqFile);
        PrintStream out = new PrintStream(statsOut);
        FastaWriter alignedNuclOut = new FastaWriter(alignedNuclOutFile);
        boolean seqHasStop = false;
        while ((seq2 = nuclSeqReader.readNextSequence()) != null) {
            String alignedNuclSeqString;
            String sanityCheckSeqString;
            Sequence protTemplate = (Sequence)protTemplateMap.get(seq2.getSeqName());
            if (protTemplate == null) {
                System.err.println("Failed to find template for " + seq2.getSeqName());
                continue;
            }
            String alignedProtSeq = protTemplate.getSeqString();
            String unalignedProtSeq = SeqUtils.getUnalignedSeqString((String)alignedProtSeq);
            String unalignedNuclSeq = seq2.getSeqString();
            int nuclLengthInProt = unalignedNuclSeq.length() / 3;
            if (nuclLengthInProt - 1 == unalignedProtSeq.length()) {
                String lastCodon = unalignedNuclSeq.substring(unalignedNuclSeq.length() - 3);
                char lastAA = ProteinUtils.getInstance().translateToProtein(lastCodon, false, 11).charAt(0);
                if (lastAA == '*' && !unalignedProtSeq.endsWith("*")) {
                    unalignedNuclSeq = unalignedNuclSeq.substring(0, unalignedNuclSeq.length() - 3);
                    nuclLengthInProt = unalignedNuclSeq.length() / 3;
                }
            }
            if (unalignedProtSeq.length() != nuclLengthInProt) {
                System.err.println("Length mismatch between " + seq2.getSeqName() + " protein [" + unalignedProtSeq.length() + "] and nucleotide sequences [" + unalignedNuclSeq.length() + "], not translating");
                continue;
            }
            int starIndex = unalignedProtSeq.indexOf(42);
            if (starIndex != -1 && starIndex != unalignedProtSeq.length() - 1) {
                System.err.println("Sequence " + seq2.getSeqName() + " has a stop codon in that isn't at the end, this could be very bad");
            }
            if (starIndex != -1) {
                seqHasStop = true;
            }
            if (!(sanityCheckSeqString = SeqUtils.getUnalignedSeqString((String)(alignedNuclSeqString = ProteinUtils.getInstance().getAlignedNucSeq(alignedProtSeq, unalignedNuclSeq, true, 11)))).equalsIgnoreCase(unalignedNuclSeq)) {
                System.err.println(sanityCheckSeqString);
                System.err.println(unalignedNuclSeq);
                System.err.println(alignedNuclSeqString);
                System.err.println("Huge error with " + seq2.getSeqName() + ", aligned nucleotide sequence doesn't match the unaligned one");
                continue;
            }
            float translScore = ProteinUtils.getInstance().getTranslScore(unalignedProtSeq, unalignedNuclSeq, true, 11);
            out.println("@ " + seq2.getSeqName() + "\t" + translScore);
            for (char c : unalignedProtSeq.toCharArray()) {
                out.print(" " + c + "  | ");
            }
            out.println();
            for (int index = 0; index < unalignedNuclSeq.length(); index += 3) {
                int end = index + 3;
                if (end > seq2.getSeqString().length()) {
                    end = seq2.getSeqString().length();
                }
                out.print(seq2.getSeqString().subSequence(index, end) + " | ");
            }
            out.println();
            String predictedProt = ProteinUtils.getInstance().translateToProtein(unalignedNuclSeq, true, 11);
            for (char c : predictedProt.toCharArray()) {
                out.print(" " + c + "  | ");
            }
            out.println();
            alignedNuclOut.writeSeq(seq2.getSeqName(), seq2.getDesc(), alignedNuclSeqString);
        }
        if (protTemplateMap.containsKey("#=GC_RF")) {
            StringBuilder mask = new StringBuilder();
            for (char c : ((Sequence)protTemplateMap.get("#=GC_RF")).getSeqString().toCharArray()) {
                if (c == 'x') {
                    mask.append("xxx");
                    continue;
                }
                if (c == '.') {
                    mask.append("...");
                    continue;
                }
                throw new IOException("I hate you. " + c);
            }
            alignedNuclOut.writeSeq("#=GC_RF", mask.toString());
        }
        out.close();
        alignedNuclOut.close();
        if (seqHasStop) {
            System.err.println("One or more protein sequences contained a stop codon, this could cause trouble if HMMER ever aligns a stop codon to a model position");
        }
    }
}

