/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.vcf;

import com.gkano.bioinfo.vcf.VCFDecoderInterface;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;

public class VCFDecoder
implements VCFDecoderInterface<String> {
    private static final byte LF = 10;
    private static final byte TAB = 9;
    private static final byte CR = 13;

    @Override
    public String decode(ByteBuffer buffer) {
        int lineStartPos = buffer.position();
        int limit = buffer.limit();
        int crs = 0;
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if (b == 13) {
                ++crs;
                continue;
            }
            if (b != 10) continue;
            int lineEndPos = buffer.position();
            if (buffer.limit() < lineEndPos + 1) {
                buffer.position(lineStartPos).limit(lineEndPos);
            } else {
                buffer.position(lineStartPos).limit(lineEndPos + 1);
            }
            byte[] line = this.parseBytes(buffer, lineEndPos - lineStartPos - 1, crs);
            crs = 0;
            if (line != null) {
                buffer.position(lineEndPos);
                buffer.limit(limit);
                lineStartPos = lineEndPos;
            }
            if (line != null && line.length == 0) continue;
            return new String(line, StandardCharsets.UTF_8);
        }
        buffer.position(lineStartPos);
        return null;
    }

    private byte[] parseBytes(ByteBuffer buffer, int length, int crs) {
        byte[] bytes = new byte[length - crs];
        for (int i = 0; i < length; ++i) {
            byte b = buffer.get();
            if (b == 13) continue;
            bytes[i] = b;
        }
        return bytes;
    }

    private byte[][] splitInTabs(byte[] bytes) {
        Object ret;
        int numTabs = 0;
        ArrayList<Integer> tabs = new ArrayList<Integer>();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 9) continue;
            ++numTabs;
            tabs.add(i);
        }
        if (numTabs == 0 || bytes[0] == 35 && bytes[1] == 35) {
            ret = new byte[1][bytes.length];
            ret[0] = Arrays.copyOf(bytes, bytes.length);
        } else {
            ret = new byte[numTabs + 1][];
            ret[0] = Arrays.copyOfRange(bytes, 0, (int)((Integer)tabs.get(0)));
            for (int i = 1; i < numTabs; ++i) {
                ret[i] = Arrays.copyOfRange(bytes, (Integer)tabs.get(i - 1) + 1, (int)((Integer)tabs.get(i)));
            }
            ret[numTabs] = Arrays.copyOfRange(bytes, (Integer)tabs.get(numTabs - 1) + 1, bytes.length);
        }
        tabs.clear();
        return ret;
    }

    @Override
    public String decode(String line) {
        return line;
    }
}

